%   Copyright  2020 University of Extremadura (UEx)
%
% customError
%  Input:
%   estimationPos: Position given by the algorithm
%   realPos:Real coordinates of the test point

%
%  Output:
%   e: Vector with the 3d error
%   zE: Beacons coordinates
% -----------------------------------------


function [error,succes] = customError(estimationPos, actualPos)
    error = sqrt(sum((estimationPos-actualPos).^2, 2));
    
    succes = 0;
    for i=1:1:length(estimationPos)
        if(estimationPos(i,3) == actualPos(i,3))
            succes = succes+1;
        end
    end
    succes = succes / length(estimationPos);
end
